/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.api.shop;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.register.ShopContentRegister;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryLimiter;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.api.shop.AbstractShopTab;

public abstract class AbstractShopEntry {
    public UUID entryUUID;
    public String title = "";
    public long entryPrice = 0L;
    public int entryCount = 1;
    public boolean isSell = false;
    public ItemStack icon = Items.f_42127_.m_7968_();
    public List<String> descriptionList = new ArrayList<String>();
    private AbstractShopEntryType entryType = null;
    private AbstractShopTab shopTab;
    private final List<AbstractShopEntryLimiter> entryLimiters = new ArrayList<AbstractShopEntryLimiter>();
    private final List<AbstractShopEntryCondition> entryConditions = new ArrayList<AbstractShopEntryCondition>();

    public AbstractShopEntry(AbstractShopTab shopTab) {
        this.shopTab = shopTab;
        this.entryUUID = UUID.randomUUID();
        for (IConstructor<AbstractShopEntryCondition> value : ShopContentRegister.SHOP_ENTRY_CONDITIONS.values()) {
            AbstractShopEntryCondition condition = value.createDefaultInstance();
            if (!Platform.isModLoaded((String)condition.getModId())) continue;
            this.entryConditions.add(condition);
        }
    }

    public void setEntryPrice(long entryPrice, int entryCount) {
        this.entryPrice = entryPrice;
        this.entryCount = entryCount;
    }

    public void setEntryType(AbstractShopEntryType entryType) {
        this.entryType = entryType;
        this.entryType.setShopEntry(this);
    }

    public AbstractShopTab getShopTab() {
        return this.shopTab;
    }

    public AbstractShopEntryType getEntryType() {
        return this.entryType;
    }

    public List<AbstractShopEntryLimiter> getEntryLimiters() {
        return this.entryLimiters;
    }

    public List<AbstractShopEntryCondition> getEntryConditions() {
        return this.entryConditions;
    }

    public void getConfig(ConfigGroup config) {
        config.addString("title", this.title, v -> {
            this.title = v;
        }, "");
        if (this.entryType.isCountable()) {
            config.addInt("count", this.entryCount, v -> {
                this.entryCount = v;
            }, 1, 1, Integer.MAX_VALUE);
        }
        config.addLong("price", this.entryPrice, v -> {
            this.entryPrice = v;
        }, 1L, 0L, Long.MAX_VALUE);
        if (this.entryType.getSellType() == AbstractShopEntryType.SellType.BOTH) {
            config.addBool("isSell", this.isSell, v -> {
                this.isSell = v;
            }, false);
        }
        config.addList("description", this.descriptionList, (ConfigValue)new StringConfig(null), (Object)"");
        ConfigGroup entryGroup = config.getGroup("type");
        if (this.entryType != null) {
            this.entryType.getConfig(entryGroup);
        }
        ConfigGroup dependenciesGroup = config.getGroup("dependencies");
        for (AbstractShopEntryCondition entryCondition : this.entryConditions) {
            entryCondition.getConfig(dependenciesGroup);
        }
    }

    public int getIndex() {
        return this.shopTab.getTabEntry().indexOf(this);
    }

    public boolean isLocked() {
        for (AbstractShopEntryCondition entryCondition : this.entryConditions) {
            if (!entryCondition.isLocked()) continue;
            return true;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_("entryPrice", this.entryPrice);
        nbt.m_128405_("entryCount", this.entryCount);
        nbt.m_128362_("entryUUID", this.entryUUID);
        CompoundTag d = new CompoundTag();
        this.icon.m_41739_(d);
        nbt.m_128365_("icon", (Tag)d);
        nbt.m_128359_("title", this.title);
        nbt.m_128379_("isSell", this.isSell);
        if (this.entryType != null) {
            nbt.m_128365_("entryType", (Tag)this.entryType.serializeNBT());
        }
        ListTag tagEntryLimiter = new ListTag();
        for (AbstractShopEntryLimiter abstractShopEntryLimiter : this.entryLimiters) {
            tagEntryLimiter.add((Object)abstractShopEntryLimiter.serializeNBT());
        }
        nbt.m_128365_("entryLimiter", (Tag)tagEntryLimiter);
        ListTag tagEntryCondition = new ListTag();
        for (AbstractShopEntryCondition entryCondition : this.entryConditions) {
            tagEntryCondition.add((Object)entryCondition.serializeNBT());
        }
        nbt.m_128365_("entryCondition", (Tag)tagEntryCondition);
        ListTag listTag = new ListTag();
        for (String s : this.descriptionList) {
            listTag.add((Object)StringTag.m_129297_((String)s));
        }
        nbt.m_128365_("description", (Tag)listTag);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.entryPrice = nbt.m_128454_("entryPrice");
        this.entryCount = nbt.m_128451_("entryCount");
        this.entryUUID = nbt.m_128342_("entryUUID");
        this.icon = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("icon"));
        this.title = nbt.m_128461_("title");
        this.isSell = nbt.m_128471_("isSell");
        if (nbt.m_128441_("entryType")) {
            this.setEntryType(AbstractShopEntryType.from(nbt.m_128469_("entryType")));
        }
        ListTag tagEntryLimiter = nbt.m_128437_("entryLimiter", 10);
        this.entryLimiters.clear();
        for (int i = 0; i < tagEntryLimiter.size(); ++i) {
            this.entryLimiters.add(AbstractShopEntryLimiter.from(tagEntryLimiter.m_128728_(i)));
        }
        ListTag tagEntryCondition = nbt.m_128437_("entryCondition", 10);
        this.entryConditions.clear();
        for (int i = 0; i < tagEntryCondition.size(); ++i) {
            AbstractShopEntryCondition condition = AbstractShopEntryCondition.from(tagEntryCondition.m_128728_(i));
            if (condition == null) continue;
            this.entryConditions.add(condition);
        }
        this.descriptionList.clear();
        ListTag tagDescription = nbt.m_128437_("description", 8);
        for (Tag tag : tagDescription) {
            this.descriptionList.add(tag.m_7916_());
        }
    }

    public String toString() {
        return "AbstractShopEntry{entryUUID=" + String.valueOf(this.entryUUID) + ", entryPrice=" + this.entryPrice + ", entryCount=" + this.entryCount + ", entryType=" + String.valueOf(this.entryType) + ", shopTab=" + String.valueOf(this.shopTab) + ", entryLimiters=" + String.valueOf(this.entryLimiters) + ", entryConditions=" + String.valueOf(this.entryConditions) + "}";
    }
}

